/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.util.Collection;
import se.egy.graphics.Drawable;
import se.egy.graphics.ImgContainer;

public class GL2DCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    private BufferStrategy backBuffer;
    private Graphics2D g;
    private Color bgColor;
    private Drawable bgImg = null;
    private volatile int cameraX = 0;
    private volatile int cameraY = 0;

    public GL2DCanvas(int width, int height, Color bgColor) {
        System.setProperty("sun.java2d.opengl", "true");
        this.bgColor = bgColor;
        this.setIgnoreRepaint(true);
        this.setSize(new Dimension(width, height));
        this.setBackground(bgColor);
    }

    public GL2DCanvas(int width, int height) {
        this(width, height, Color.BLACK);
    }

    public void initRenderingMode() {
        this.requestFocus();
        BufferCapabilities bufCap = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED);
        try {
            this.createBufferStrategy(2, bufCap);
        }
        catch (AWTException ex) {
            this.createBufferStrategy(2);
        }
        this.backBuffer = this.getBufferStrategy();
        while (this.backBuffer.getDrawGraphics() == null) {
        }
        this.clearScreen();
    }

    public void render(Collection<? extends Drawable> drawableList) {
        this.beginRender();
        this.openRender(drawableList);
        this.show();
    }

    public void render(Drawable[] drawableArray) {
        this.beginRender();
        this.openRender(drawableArray);
        this.show();
    }

    public void render(Drawable drawable) {
        this.beginRender();
        drawable.draw(this.g);
        this.show();
    }

    public void render(Image img, int x, int y) {
        this.beginRender();
        this.g.drawImage(img, x, y, null);
        this.show();
    }

    public void openRender(Drawable drawable) {
        drawable.draw(this.g);
    }

    public void openRender(Drawable[] drawableArray) {
        Drawable[] drawableArray2 = drawableArray;
        int n = drawableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Drawable drawObj = drawableArray2[n2];
            if (drawObj != null) {
                drawObj.draw(this.g);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRender(Collection<? extends Drawable> drawableList) {
        Collection<? extends Drawable> collection = drawableList;
        synchronized (collection) {
            for (Drawable drawable : drawableList) {
                drawable.draw(this.g);
            }
        }
    }

    public void openRender(Image img, int x, int y) {
        this.g.drawImage(img, x, y, null);
    }

    public void beginRender() {
        this.g = (Graphics2D)this.backBuffer.getDrawGraphics();
        this.g.translate(-this.cameraX, -this.cameraY);
        if (this.bgImg == null) {
            this.g.setColor(this.bgColor);
            this.g.fillRect(0 - this.cameraX, 0 - this.cameraY, this.getWidth(), this.getHeight());
        } else {
            this.bgImg.draw(this.g);
        }
    }

    @Override
    public void show() {
        this.g.dispose();
        this.backBuffer.show();
        Toolkit.getDefaultToolkit().sync();
    }

    public void clearScreen() {
        this.beginRender();
        this.show();
    }

    public Graphics2D getGraphics2D() {
        Graphics2D graphics = (Graphics2D)this.backBuffer.getDrawGraphics();
        return graphics;
    }

    public void cameraMoveTo(double x, double y) {
        this.cameraX = (int)x;
        this.cameraY = (int)y;
    }

    @Override
    public void setBackground(Color color) {
        this.bgColor = color;
        this.bgImg = null;
    }

    public void setBackground(String pathToImage) {
        this.bgImg = new ImgContainer(0, 0, pathToImage);
    }

    public void setBackground(Image image) {
        this.bgImg = new ImgContainer(0, 0, image);
    }

    public void setBackground(Drawable background) {
        this.bgImg = background;
    }
}

