/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;
import se.egy.graphics.DisplayException;
import se.egy.graphics.GL2DCanvas;
import se.egy.graphics.GameCloseException;

public class GL2DWindow
extends GL2DCanvas {
    private static final long serialVersionUID = 1L;
    private String title;
    private boolean fullScreenMode = false;
    private JFrame jf;
    private GraphicsDevice device;
    private DisplayMode oldDM = null;

    public GL2DWindow(String title, int width, int height, boolean fullScreenMode) {
        super(width, height);
        this.title = title;
        this.fullScreenMode = fullScreenMode;
        System.setProperty("sun.java2d.opengl", "true");
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GL2DWindow.this.createWindow();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fullScreenMode) {
            this.jf.setBounds(0, 0, width, height);
        }
    }

    public GL2DWindow(String title, int width, int height) {
        this(title, width, height, false);
    }

    private void createWindow() {
        this.jf = new JFrame(this.title);
        this.jf.add(this);
        if (this.fullScreenMode) {
            int bitDepth = -1;
            try {
                bitDepth = this.getBitDepth(this.getWidth(), this.getHeight());
            }
            catch (DisplayException de) {
                System.err.println(de.getMessage());
            }
            DisplayMode dm = new DisplayMode(this.getWidth(), this.getHeight(), bitDepth, 0);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.device = env.getDefaultScreenDevice();
            this.jf.setUndecorated(true);
            this.jf.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.oldDM = this.device.getDisplayMode();
            this.device.setFullScreenWindow(this.jf);
            this.device.setDisplayMode(dm);
        } else {
            this.jf.setResizable(false);
            this.jf.pack();
            this.jf.setLocationRelativeTo(null);
            this.jf.setDefaultCloseOperation(3);
        }
        this.jf.setIgnoreRepaint(true);
        this.jf.setVisible(true);
        this.initRenderingMode();
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.getDisplayModes();
    }

    public static void availableDisplayModes() {
        DisplayMode[] modes = GL2DWindow.getAvailableDisplayModes();
        int i = 0;
        while (i < modes.length) {
            DisplayMode DM = modes[i];
            System.out.println(i + ") Resolution : " + DM.getWidth() + "x" + DM.getHeight() + " \tBit-Depth: " + DM.getBitDepth());
            ++i;
        }
    }

    private int getBitDepth(int w, int h) throws DisplayException {
        DisplayMode[] modes = GL2DWindow.getAvailableDisplayModes();
        int i = 0;
        while (i < modes.length) {
            DisplayMode DM = modes[i];
            if (DM.getWidth() == w && DM.getHeight() == h) {
                return DM.getBitDepth();
            }
            ++i;
        }
        throw new DisplayException("Felaktig uppl\u00f6sning. Testa med GameScreen.availableDisplayModes()");
    }

    public void close() throws GameCloseException {
        if (this.fullScreenMode) {
            try {
                try {
                    this.device.setDisplayMode(this.oldDM);
                    this.device.setFullScreenWindow(null);
                }
                catch (Exception e) {
                    throw new GameCloseException("Kunde inte st\u00e4ng f\u00f6nstret");
                }
            }
            finally {
                this.fullScreenMode = false;
            }
        }
        this.jf.dispose();
    }
}

