/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.util.Collection;
import javax.swing.JFrame;
import se.egy.graphics.DisplayException;
import se.egy.graphics.Drawable;
import se.egy.graphics.GameCloseException;
import se.egy.graphics.ImgContainer;

public class GameScreen {
    private int height;
    private int width;
    private String title;
    private boolean fullScreenMode = false;
    private JFrame jf;
    private Canvas canvas = new Canvas();
    private GraphicsDevice device;
    private BufferStrategy backBuffer;
    private Graphics2D g;
    private Color bgColor = Color.BLACK;
    private Drawable bgImg = null;
    private DisplayMode oldDM = null;
    private volatile int cameraX = 0;
    private volatile int cameraY = 0;

    public GameScreen(String title, int width, int height, boolean fullScreenMode) {
        this.width = width;
        this.height = height;
        this.title = title;
        this.fullScreenMode = fullScreenMode;
        System.setProperty("sun.java2d.opengl", "true");
        this.canvas.setIgnoreRepaint(true);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GameScreen.this.createWindow();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fullScreenMode) {
            this.jf.setBounds(0, 0, width, height);
        }
        this.clearScreen();
    }

    public GameScreen(String title, int width, int height) {
        this(title, width, height, false);
    }

    private void createWindow() {
        this.jf = new JFrame(this.title);
        this.canvas.setSize(new Dimension(this.width, this.height));
        this.canvas.setBackground(this.bgColor);
        this.jf.add(this.canvas);
        if (this.fullScreenMode) {
            int bitDepth = -1;
            try {
                bitDepth = this.getBitDepth(this.width, this.height);
            }
            catch (DisplayException de) {
                System.err.println(de.getMessage());
            }
            DisplayMode dm = new DisplayMode(this.width, this.height, bitDepth, 0);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.device = env.getDefaultScreenDevice();
            this.jf.setUndecorated(true);
            this.jf.setBounds(0, 0, this.width, this.height);
            this.oldDM = this.device.getDisplayMode();
            this.device.setFullScreenWindow(this.jf);
            this.device.setDisplayMode(dm);
        } else {
            this.jf.setResizable(false);
            this.jf.pack();
            this.jf.setLocationRelativeTo(null);
            this.jf.setDefaultCloseOperation(3);
        }
        this.jf.setIgnoreRepaint(true);
        this.jf.setVisible(true);
        this.canvas.requestFocus();
        BufferCapabilities bufCap = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED);
        try {
            this.canvas.createBufferStrategy(2, bufCap);
        }
        catch (AWTException ex) {
            this.canvas.createBufferStrategy(2);
        }
        this.backBuffer = this.canvas.getBufferStrategy();
        while (this.backBuffer.getDrawGraphics() == null) {
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        this.bgImg = null;
    }

    public void setBackground(String pathToImage) {
        this.bgImg = new ImgContainer(0, 0, pathToImage);
    }

    public void setBackground(Image image) {
        this.bgImg = new ImgContainer(0, 0, image);
    }

    public void setBackground(Drawable background) {
        this.bgImg = background;
    }

    public void cameraMoveTo(double x, double y) {
        this.cameraX = (int)x;
        this.cameraY = (int)y;
    }

    public void setKeyListener(KeyListener keyListener) {
        this.canvas.addKeyListener(keyListener);
    }

    public void setMouseListner(MouseListener mouseListener) {
        this.canvas.addMouseListener(mouseListener);
    }

    public void setMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.canvas.addMouseMotionListener(mouseMotionListener);
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public Graphics2D getGraphics2D() {
        Graphics2D graphics = (Graphics2D)this.backBuffer.getDrawGraphics();
        return graphics;
    }

    public void render(Collection<? extends Drawable> drawableList) {
        this.beginRender();
        this.openRender(drawableList);
        this.show();
    }

    public void render(Drawable[] drawableArray) {
        this.beginRender();
        this.openRender(drawableArray);
        this.show();
    }

    public void render(Drawable drawable) {
        this.beginRender();
        drawable.draw(this.g);
        this.show();
    }

    public void render(Image img, int x, int y) {
        this.beginRender();
        this.g.drawImage(img, x, y, null);
        this.show();
    }

    public void openRender(Drawable drawable) {
        drawable.draw(this.g);
    }

    public void openRender(Drawable[] drawableArray) {
        Drawable[] drawableArray2 = drawableArray;
        int n = drawableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Drawable drawObj = drawableArray2[n2];
            try {
                drawObj.draw(this.g);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRender(Collection<? extends Drawable> drawableList) {
        Collection<? extends Drawable> collection = drawableList;
        synchronized (collection) {
            for (Drawable drawable : drawableList) {
                drawable.draw(this.g);
            }
        }
    }

    public void openRender(Image img, int x, int y) {
        this.g.drawImage(img, x, y, null);
    }

    public void beginRender() {
        this.g = (Graphics2D)this.backBuffer.getDrawGraphics();
        this.g.translate(-this.cameraX, -this.cameraY);
        if (this.bgImg == null) {
            this.g.setColor(this.bgColor);
            this.g.fillRect(0 - this.cameraX, 0 - this.cameraY, this.width, this.height);
        } else {
            this.bgImg.draw(this.g);
        }
    }

    public void show() {
        this.g.dispose();
        this.backBuffer.show();
        Toolkit.getDefaultToolkit().sync();
    }

    public void clearScreen() {
        this.beginRender();
        this.show();
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.getDisplayModes();
    }

    public static void availableDisplayModes() {
        DisplayMode[] modes = GameScreen.getAvailableDisplayModes();
        int i = 0;
        while (i < modes.length) {
            DisplayMode DM = modes[i];
            System.out.println(i + ") Resolution : " + DM.getWidth() + "x" + DM.getHeight() + " \tBit-Depth: " + DM.getBitDepth());
            ++i;
        }
    }

    private int getBitDepth(int w, int h) throws DisplayException {
        DisplayMode[] modes = GameScreen.getAvailableDisplayModes();
        int i = 0;
        while (i < modes.length) {
            DisplayMode DM = modes[i];
            if (DM.getWidth() == w && DM.getHeight() == h) {
                return DM.getBitDepth();
            }
            ++i;
        }
        throw new DisplayException("Felaktig uppl\u00f6sning. Testa med GameScreen.availableDisplayModes()");
    }

    public void close() throws GameCloseException {
        if (this.fullScreenMode) {
            try {
                try {
                    this.device.setDisplayMode(this.oldDM);
                    this.device.setFullScreenWindow(null);
                }
                catch (Exception e) {
                    throw new GameCloseException("Kunde inte st\u00e4ng f\u00f6nstret");
                }
            }
            finally {
                this.fullScreenMode = false;
            }
        }
        this.jf.dispose();
    }
}

