/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class ImageTools {
    private ImageTools() {
    }

    public static Image[] slice(Image image, int cols, int rows, int margin) {
        BufferedImage buffImg = ImageTools.imgToBufferedImg(image);
        Image[] tile = new BufferedImage[cols * rows];
        int width = (buffImg.getWidth(null) - margin * (cols - 1)) / cols;
        int height = (buffImg.getHeight(null) - margin * (rows - 1)) / rows;
        int imgNr = 0;
        int dx = 0;
        int dy = 0;
        int y = 0;
        while (y < rows) {
            int x = 0;
            while (x < cols) {
                tile[imgNr] = buffImg.getSubimage(width * x + dx, height * y + dy, width, height);
                dx += margin;
                ++imgNr;
                ++x;
            }
            dx = 0;
            dy += margin;
            ++y;
        }
        return tile;
    }

    public static BufferedImage imgToBufferedImg(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage buffImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2d = buffImg.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return buffImg;
    }

    public static BufferedImage[] imgToBufferedImg(Image[] images) {
        BufferedImage[] buffImg = new BufferedImage[images.length];
        int i = 0;
        while (i < images.length) {
            buffImg[i] = ImageTools.imgToBufferedImg(images[i]);
            ++i;
        }
        return buffImg;
    }

    public static VolatileImage createVolatileImage(Image image) {
        BufferedImage buffImg = null;
        buffImg = image instanceof BufferedImage ? (BufferedImage)image : ImageTools.imgToBufferedImg(image);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        int width = buffImg.getWidth();
        int height = buffImg.getHeight();
        int transparency = buffImg.getTransparency();
        VolatileImage vImg = graphicsConfiguration.createCompatibleVolatileImage(width, height, transparency);
        Graphics2D g2d = vImg.createGraphics();
        g2d.setComposite(AlphaComposite.Src);
        g2d.drawImage((Image)buffImg, 0, 0, null);
        g2d.dispose();
        return vImg;
    }

    public static VolatileImage[] createVolatileImage(Image[] images) {
        VolatileImage[] vImg = new VolatileImage[images.length];
        int i = 0;
        while (i < images.length) {
            vImg[i] = ImageTools.createVolatileImage(images[i]);
            ++i;
        }
        return vImg;
    }

    public static boolean copyImageToVolatileImage(VolatileImage vImg, Image image) {
        BufferedImage buffImg = null;
        buffImg = image instanceof BufferedImage ? (BufferedImage)image : ImageTools.imgToBufferedImg(image);
        if (vImg == null) {
            return false;
        }
        try {
            Graphics2D g2d = vImg.createGraphics();
            g2d.setComposite(AlphaComposite.Src);
            g2d.drawImage((Image)buffImg, 0, 0, null);
            g2d.dispose();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

