/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.swing.ImageIcon;
import se.egy.graphics.Drawable;

public class ImgContainer
implements Drawable {
    private double x;
    private double y;
    private BufferedImage image;
    private VolatileImage vImg = null;

    public ImgContainer(int x, int y, Image image) {
        this.x = x;
        this.y = y;
        this.image = this.getBufferedImage(image);
    }

    public ImgContainer(int x, int y, BufferedImage image) {
        this.x = x;
        this.y = y;
        this.image = image;
    }

    public ImgContainer(int x, int y, String pathToImage) {
        this.x = x;
        this.y = y;
        if (((String)pathToImage).charAt(0) != '/') {
            pathToImage = "/" + (String)pathToImage;
        }
        this.image = this.getBufferedImage(new ImageIcon(this.getClass().getResource((String)pathToImage)).getImage());
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage(this.getVolatileImage(), (int)this.x, (int)this.y, null);
    }

    private VolatileImage getVolatileImage() {
        if (this.vImg == null || this.vImg.contentsLost()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            int transparency = this.image.getTransparency();
            this.vImg = graphicsConfiguration.createCompatibleVolatileImage(width, height, transparency);
            Graphics2D g2d = this.vImg.createGraphics();
            g2d.setComposite(AlphaComposite.Src);
            g2d.drawImage((Image)this.image, 0, 0, null);
            g2d.dispose();
        }
        return this.vImg;
    }

    private BufferedImage getBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage buffImg = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2d = buffImg.createGraphics();
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return buffImg;
    }

    public int getX() {
        return (int)this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void moveX(double xStep) {
        this.x += xStep;
    }

    public int getY() {
        return (int)this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void moveY(double yStep) {
        this.y += yStep;
    }

    public int getWidth() {
        return this.image.getWidth(null);
    }

    public int getHeight() {
        return this.image.getHeight(null);
    }
}

