/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import se.egy.graphics.Drawable;

public class JWin
extends Canvas
implements Runnable {
    private static final long serialVersionUID = -2588972793371518313L;
    private int height;
    private int width;
    private String title;
    private JFrame jf;
    private BufferStrategy backBuffer;
    private long lastUpdateTime;
    private long renderDelay;
    private volatile boolean running = true;
    private Color bgColor = Color.BLACK;
    private List<Drawable> drawableList = Collections.synchronizedList(new ArrayList());

    public JWin(String title, int fps, int width, int height) {
        this.width = width;
        this.height = height;
        this.title = title;
        this.renderDelay = 1000000000 / fps;
        this.createWindow();
    }

    private void createWindow() {
        this.setSize(this.width, this.height);
        this.jf = new JFrame(this.title);
        this.jf.add(this);
        this.jf.setMinimumSize(new Dimension(this.width, this.height));
        this.jf.pack();
        this.jf.setLocationRelativeTo(null);
        this.jf.setVisible(true);
        this.jf.setDefaultCloseOperation(3);
        this.setFocusable(true);
        this.createBufferStrategy(2);
        this.backBuffer = this.getBufferStrategy();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void addDrawable(Drawable drawable) {
        this.drawableList.add(drawable);
    }

    public void addDrawableList(Collection<Drawable> drawableList) {
        this.drawableList.addAll(drawableList);
    }

    public void addDrawableList(Drawable[] drawableList) {
        List<Drawable> list = Arrays.stream(drawableList).collect(Collectors.toList());
        this.addDrawableList(list);
    }

    public void removeDrawable(Drawable drawable) {
        this.drawableList.remove(drawable);
    }

    public void removeDrawableList(Collection<Drawable> drawableList) {
        this.drawableList.removeAll(drawableList);
    }

    public void removeDrawableList(Drawable[] drawableList) {
        List<Drawable> list = Arrays.stream(drawableList).collect(Collectors.toList());
        this.removeDrawableList(list);
    }

    public void removeAll() {
        this.drawableList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render() {
        Graphics2D g = (Graphics2D)this.backBuffer.getDrawGraphics();
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.width, this.height);
        List<Drawable> list = this.drawableList;
        synchronized (list) {
            for (Drawable drawObj : this.drawableList) {
                drawObj.draw(g);
            }
        }
        g.dispose();
        this.backBuffer.show();
    }

    @Override
    public void run() {
        this.lastUpdateTime = System.nanoTime();
        while (this.running) {
            long deltaTime = System.nanoTime() - this.lastUpdateTime;
            if (deltaTime <= this.renderDelay) continue;
            this.lastUpdateTime = System.nanoTime();
            this.render();
        }
    }

    public void stop() {
        this.running = false;
    }
}

