/*
 * Decompiled with CFR 0.152.
 */
package se.egy.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import se.egy.graphics.Drawable;
import se.egy.graphics.Tile;

public class TileMap
implements Drawable {
    private int cols;
    private int rows;
    private int width;
    private int height;
    private final int tileSize;
    private int[][] tileMap;
    private final Color transparent = new Color(0, 0, 0, 0);
    private Color[] colorArray = new Color[]{Color.BLACK, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY, Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.ORANGE, Color.WHITE, Color.PINK, Color.CYAN, Color.MAGENTA, this.transparent, this.transparent, this.transparent};
    private Image[] tileImgArray;
    private BufferedImage tileMapImg = null;
    private VolatileImage vImg = null;
    private boolean redrawMap = false;
    private int nrOfItems = 16;
    private Type tileType = Type.COL;
    private Tile[] tiles = new Tile[4];

    public TileMap(String pathToMap, int tileSize) {
        this.initTiles();
        this.tileSize = tileSize;
        this.readMapData(pathToMap);
        this.tilesToImg();
    }

    public TileMap(String pathToMap, int tileSize, Color[] colorArray) {
        this.initTiles();
        this.tileSize = tileSize;
        this.colorArray = colorArray;
        this.nrOfItems = colorArray.length;
        this.readMapData(pathToMap);
        this.tilesToImg();
    }

    public TileMap(String pathToMap, int tileSize, Image[] tileImgArray) {
        this.initTiles();
        this.tileSize = tileSize;
        this.tileImgArray = tileImgArray;
        this.nrOfItems = tileImgArray.length;
        this.tileType = Type.IMG;
        this.readMapData(pathToMap);
        this.tilesToImg();
    }

    private void initTiles() {
        int i = 0;
        while (i < 4) {
            this.tiles[i] = new Tile();
            ++i;
        }
    }

    private void tilesToImg() {
        this.tileMapImg = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = (Graphics2D)this.tileMapImg.getGraphics();
        int x = 0;
        while (x < this.cols) {
            int y = 0;
            while (y < this.rows) {
                int tile = this.tileMap[x][y];
                if (this.tileType == Type.IMG && tile < this.nrOfItems) {
                    g.drawImage(this.tileImgArray[tile], x * this.tileSize, y * this.tileSize, null);
                } else {
                    if (tile < this.nrOfItems) {
                        g.setColor(this.colorArray[tile]);
                    } else {
                        g.setColor(this.colorArray[0]);
                    }
                    g.fillRect(x * this.tileSize, y * this.tileSize, this.tileSize, this.tileSize);
                }
                ++y;
            }
            ++x;
        }
    }

    private VolatileImage getVolatileImage() {
        if (this.vImg == null || this.vImg.contentsLost() || this.redrawMap) {
            if (!this.redrawMap) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                int transparency = this.tileMapImg.getTransparency();
                this.vImg = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height, transparency);
            }
            Graphics2D g2d = this.vImg.createGraphics();
            g2d.setComposite(AlphaComposite.Src);
            g2d.drawImage((Image)this.tileMapImg, 0, 0, null);
            g2d.dispose();
            this.redrawMap = false;
        }
        return this.vImg;
    }

    private void readMapData(String pathToMap) {
        if (((String)pathToMap).charAt(0) != '/') {
            pathToMap = "/" + (String)pathToMap;
        }
        BufferedReader mapFile = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream((String)pathToMap)));
        try {
            this.cols = Integer.parseInt(mapFile.readLine());
            this.rows = Integer.parseInt(mapFile.readLine());
        }
        catch (Exception e) {
            System.out.println("Fel vid inl\u00e4sning av antalet rader/kolumner fr\u00e5n mapFile. " + e.getMessage());
        }
        this.width = this.cols * this.tileSize;
        this.height = this.rows * this.tileSize;
        this.tileMap = new int[this.cols][this.rows];
        int row = 0;
        while (row < this.rows) {
            String rowAsString = null;
            try {
                rowAsString = mapFile.readLine();
            }
            catch (IOException e) {
                System.out.println("Fel vid inl\u00e4sning av rader nr: " + (row + 3) + " fr\u00e5n mapFile. " + e.getMessage());
            }
            String[] tile = rowAsString.split(" ");
            int col = 0;
            while (col < this.cols) {
                this.tileMap[col][row] = Integer.parseInt(tile[col], 16);
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage(this.getVolatileImage(), 0, 0, null);
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getTileMapWidthInPx() {
        return this.getCols() * this.getTileSize();
    }

    public int getTileMapHeightInPx() {
        return this.getRows() * this.getTileSize();
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getTile(double col, double row) {
        try {
            return this.tileMap[(int)col][(int)row];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public int getTileFromPx(double x, double y) {
        if (x < 0.0) {
            x -= (double)this.tileSize;
        }
        if (y < 0.0) {
            y -= (double)this.tileSize;
        }
        try {
            return this.tileMap[(int)x / this.tileSize][(int)y / this.tileSize];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public Tile[] getTilesFromRect(int x, int y, int width, int height) {
        this.setTileInArray(0, x, y, this.getTileFromPx(x, y));
        this.setTileInArray(1, x + width, y, this.getTileFromPx(x + width, y));
        this.setTileInArray(2, x + width, y + height, this.getTileFromPx(x + width, y + height));
        this.setTileInArray(3, x, y + height, this.getTileFromPx(x, y + height));
        return this.tiles;
    }

    public Tile[] getTilesFromSquare(int x, int y, int side) {
        return this.getTilesFromRect(x, y, side, side);
    }

    private void setTileInArray(int pos, int x, int y, int value) {
        if (x < 0) {
            x -= this.tileSize;
        }
        if (y < 0) {
            y -= this.tileSize;
        }
        int col = x / this.tileSize;
        int row = y / this.tileSize;
        this.tiles[pos].COLUMN = col;
        this.tiles[pos].ROW = row;
        this.tiles[pos].VALUE = value;
    }

    public void setTile(int col, int row, int value) {
        this.tileMap[col][row] = value;
        this.setTileImg(col, row, value);
    }

    private void setTileImg(int x, int y, int tile) {
        Graphics g = this.tileMapImg.getGraphics();
        if (this.tileType == Type.IMG && tile < this.nrOfItems) {
            g.drawImage(this.tileImgArray[tile], x * this.tileSize, y * this.tileSize, null);
        } else {
            if (tile < this.nrOfItems) {
                g.setColor(this.colorArray[tile]);
            } else {
                g.setColor(this.colorArray[0]);
            }
            g.fillRect(x * this.tileSize, y * this.tileSize, this.tileSize, this.tileSize);
        }
        this.redrawMap = true;
    }

    public void setTileFromPx(double x, double y, int value) {
        this.setTile((int)x / this.tileSize, (int)y / this.tileSize, value);
    }

    private static enum Type {
        COL,
        IMG;

    }
}

