package se.egy.examples.tilemap;

import se.egy.graphics.*;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class TestMap_5 implements KeyListener{
	boolean gameRunning = true;
	
	private HashMap<String, Boolean> keyDown = new HashMap<String, Boolean>();

	private TileMap map;

	private ImgContainer player;
	private Image[] tiles;

	private GameScreen gameScreen = new GameScreen("Game", 800, 576, false); // OBS! Skall Vara false.
	
	int camX = 0;
	int camY = 0;

	public TestMap_5(){
		loadImages();
		
		map = new TileMap("mapLarge-mario.txt", 32, tiles);
		
		gameScreen.setBackground(map);
		
		gameScreen.setKeyListener(this);
		
		keyDown.put("left", false);
		keyDown.put("right", false);
		keyDown.put("up", false);
		keyDown.put("down", false);
		keyDown.put("esc", false);
		
		gameLoop();
	}

	public void loadImages(){
		Image playerImg = new ImageIcon(getClass().getResource("/playerImg.png")).getImage();		
		player = new ImgContainer(45, 45, playerImg);
		
		
		Image tileSet = new ImageIcon(getClass().getResource("/tileset-mario.png")).getImage();
		tiles = ImageTools.slice(tileSet, 16, 16, 0);
	}

	public void update(long delta){
		int nx = player.getX();
		int ny = player.getY();
		int w = player.getWidth();
		
		if (keyDown.get("left")) {
			nx--;
		}
		if (keyDown.get("right") ) {
			nx++;
		}
		if (keyDown.get("up")) {
			ny--;
		}
		if (keyDown.get("down")) {
			ny++;
		}
		if(keyDown.get("esc")) {
			gameRunning = false;
		}
		
		boolean move = true;
		
		Tile[] tiles = map.getTilesFromSquare(nx, ny, w);
		
		for(int i = 0; i < 4; i++) {
			if(tiles[i].VALUE != 0x0E) { // 0x0E vid mario, 0xA vid 16 bilder, 1 vid färger
				if(tiles[i].VALUE == 0x1A) {
					map.setTile(tiles[i].COLUMN, tiles[i].ROW, 0x0E);
				}else {
					move = false;
					break;
				}
			}
		}

		if(move) {
			player.setX(nx);
			player.setY(ny);
		}
		
		if(player.getX() >= 300) {
			camX = player.getX() - 300;
		}
		if(camX > 416){
			camX = 416;
		}
		gameScreen.cameraMoveTo(camX, 0);
	}
	
	public void render(){
		gameScreen.render(player);		
	}

	public void gameLoop(){
		long last = System.nanoTime();
		while(gameRunning){
			long delta = (System.nanoTime() - last);
			last = System.nanoTime();
			update(delta);
			render();
			
			try { Thread.sleep(4); } catch (Exception e) {}; // Fördröjning
		}
		
		try{
			gameScreen.close();
		}catch(GameCloseException e) {
			System.out.println(e);
		}
	}
	
	public void keyTyped(KeyEvent e) {
	}

	public void keyPressed(KeyEvent e) {
		if (e.getKeyCode() == KeyEvent.VK_LEFT) {
			keyDown.put("left", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
			keyDown.put("right", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			keyDown.put("down", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			keyDown.put("up", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
			keyDown.put("esc", true);
		}
	}

	public void keyReleased(KeyEvent e) {
		if (e.getKeyCode() == KeyEvent.VK_LEFT) {
			keyDown.put("left", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
			keyDown.put("right", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			keyDown.put("down", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			keyDown.put("up", false);
		}
	}

	public static void main(String[] args) {
		new TestMap_5();
	}
}
