import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;

import se.egy.graphics.Drawable;

/**
 * MINA ÄNDRINGAR
 * 1) import se.egy.graphics.Drawable; 
 * 2) public class Entity implements Drawable
 * 3) Bytt namn på metooden paint till draw
 */
public class Entity implements Drawable{
	// x, y position på figuren i px
	private double x, y;

	// Rörelseriktiningen på entiteten */
	private int dx = 0, dy = 0;

	// Hastigheten på spelfiguren i px/s
	private int speed;

	// Bilden som representerar figuren
	private Image image;

	// Rutnätet med spelplanen
	private Map map;
	
	// Värde i rutnätet som inte spelfiguren kan gå till, typ en vägg.
	private int blocked = 1;

	/**
	 * Konstruktor
	 * 
	 * @param image	bilden som representerar spelfiguren
	 * @param map	rutnätet med spelplanen
	 * @param x		x-position på skärmen
	 * @param y		y-position på skärmen
	 * @param speed	rörelsehastighet i px/s som figuren skall röra sig med
	 */
	public Entity(Image image, Map map, double x, double y, int speed) {
		this.image = image;
		this.map = map;
		this.x = x;
		this.y = y;
		this.speed = speed;
	}


	/**
	 * Förflyttar spelfiguren beroende på förfluten tid
	 * @param deltaTime tid som förflutit sedan förra uppdateringen i nano sekunder
	 */
	public void move(long deltaTime) {
		double nx = x + dx*speed*(deltaTime/1000000000.0);
		double ny = y + dy*speed*(deltaTime/1000000000.0);


		// Kontrollerar om den nya positionen fungerar
		if (!validLocation(nx, ny)) {
			if (validLocation(nx, y)) {
				// if it doesn't then change our position to the new position
				x = nx;
			}

			if (validLocation(x, ny)) {
				// if it doesn't then change our position to the new position
				y = ny;
			}	
		}else {
			x = nx;
			y = ny;
		}
	}


	/**
	 * Kontrollerar om en position på skärmen inte är blockerd
	 * @param nx
	 * @param ny
	 * @return
	 */
	public boolean validLocation(double nx, double ny) {
		if(hitTile(nx, ny, blocked).x != -1) {
			return false;
		}else {
			return true;
		} 
	}
	

	private Point hitTile(double xPos, double yPos, int tileValue) {
		int x = -1, y = -1;
		
		if (map.getTileFromPx(xPos, yPos) == tileValue) {
			x = (int)xPos/map.getTileSize();
			y = (int)yPos/map.getTileSize();
			return new Point(x, y);
		}
		if (map.getTileFromPx(xPos + image.getWidth(null)-1, yPos) == tileValue) {
			x = (int)(xPos + image.getWidth(null)-1)/map.getTileSize();
			y = (int)yPos/map.getTileSize();
			return new Point(x, y);
		}
		if (map.getTileFromPx(xPos + image.getWidth(null)-1, yPos + image.getHeight(null)-1) == tileValue) {
			x = (int)(xPos + image.getWidth(null)-1)/map.getTileSize();
			y = (int)(yPos + image.getHeight(null)-1)/map.getTileSize();
			return new Point(x, y);
		}
		if (map.getTileFromPx(xPos, yPos + image.getHeight(null)-1) == tileValue) {
			x = (int)(xPos)/map.getTileSize();
			y = (int)(yPos + image.getHeight(null)-1)/map.getTileSize();
			return new Point(x, y);
		}
		
		return new Point(x, y);
	}
	/**
	 * Kontrollerar om spelfiguren ligger på en ruta med ett visst värde.
	 * 
	 * @param tileValue
	 * @return koordinaten på rutan i rutnätet med sökt värde Om den inte finns returneras(-1,-1)
	 */
	public Point  hitTile(int tileValue) {		
		return hitTile(x, y, tileValue);
	}

	/**
	 * Draw this entity to the graphics context provided.
	 * 
	 * @param g The graphics context to which the entity should be drawn
	 */
	public void draw(Graphics2D g) {
		g.drawImage(image, (int)x, (int)y, null);
	}

	// Getters och Setters
	public int getDx() {
		return dx;
	}

	public void setDx(int dx) {
		this.dx = dx;
	}

	public int getDy() {
		return dy;
	}

	public void setDy(int dy) {
		this.dy = dy;
	}


	public double getX() {
		return x;
	}


	public void setX(double x) {
		this.x = x;
	}


	public double getY() {
		return y;
	}


	public void setY(double y) {
		this.y = y;
	}
}

