import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;

import javax.swing.ImageIcon;

import se.egy.graphics.Drawable;
import se.egy.graphics.GameScreen;
import se.egy.graphics.ImgContainer;


public class Game implements KeyListener {

	boolean gameRunning = true;
	int points = 0;
	
	private HashMap<String, Boolean> keyDown = new HashMap<String, Boolean>();

	private Map map;

	private Entity player;

	private GameScreen gameScreen = new GameScreen("Game", 800, 576, false); // OBS! Skall Vara false.

	public Game(){
		map = new Map("map2.txt", 32);
		gameScreen.setBackground(map);
		
		gameScreen.setKeyListener(this);
		
		keyDown.put("left", false);
		keyDown.put("right", false);
		keyDown.put("up", false);
		keyDown.put("down", false);

		loadImages();
		gameLoop();
	}

	public void loadImages(){
		Image img = new ImageIcon(getClass().getResource("/playerImg.png")).getImage();		
		player = new Entity(img, map, 45, 45, 40);
	}

	public void update(long delta){

		player.setDx(0);
		player.setDy(0);
		
		if (keyDown.get("left")) {
			player.setDx(-1);
		}
		if (keyDown.get("right")) {
			player.setDx(1);
		}
		if (keyDown.get("up")) {
			player.setDy(-1);
		}
		if (keyDown.get("down")) {
			player.setDy(1);;
		}

		player.move(delta);
		
		Point hitTile = player.hitTile(2);
		
		if(hitTile.x != -1) {
			points++;
			map.setTile(hitTile.x, hitTile.y, 0);
		}
	}

	public void render(){
		gameScreen.render(player);
	}

	public void gameLoop(){
		long last = System.nanoTime();
		while(gameRunning){
			long delta = (System.nanoTime() - last);
			last = System.nanoTime();
			update(delta);
			render();
			// Fördröjning
			try { Thread.sleep(4); } catch (Exception e) {};
		}
	}

	/** Spelets tangentbordslyssnare */
	public void keyTyped(KeyEvent e) {
	}

	public void keyPressed(KeyEvent e) {
		// check the keyboard and record which keys are pressed

		if (e.getKeyCode() == KeyEvent.VK_LEFT) {
			keyDown.put("left", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
			keyDown.put("right", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			keyDown.put("down", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			keyDown.put("up", true);
		}
	}

	public void keyReleased(KeyEvent e) {
		// check the keyboard and record which keys are released

		if (e.getKeyCode() == KeyEvent.VK_LEFT) {
			keyDown.put("left", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
			keyDown.put("right", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			keyDown.put("down", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			keyDown.put("up", false);
		}
	}

	public static void main(String[] args) {
		new Game();
	}
}
