import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;

import javax.swing.ImageIcon;

import se.egy.graphics.Drawable;
import se.egy.graphics.GameScreen;
import se.egy.graphics.ImgContainer;
/**
 * Min variant av Kevin Glass klass Game från
 * http://www.cokeandcode.com/main/tutorials/tile-maps/ med GameScreen-klassen, 2019-09-23
 * Försökt anpassa Kevins kod att passa med GameScreen-klassen.
 * 
 * Har ändrat ett metodnamn och lagt till för att mer passa kursens upplägg och för bättre struktur. 
 * Detta är dock en smaksak.
 * 
 * logic -> update
 * loadImages (laddar in bilder, anropas från konstruktor)
 * render (renderar bilder, anropas från gameLoop)
 * 
 * Bytt från variabler till HashMap för att lagra tangentbordshändelser
 * 
 * @author henrikbygren
 */

public class Game implements KeyListener {
	/** The sprite we're going to use for our player */
	private Image sprite;

	boolean gameRunning = true;

	/** Lagrar tillstånd för tangenter, true -> nertryckt */
	private HashMap<String, Boolean> keyDown = new HashMap<String, Boolean>();

	/** The map our player will wander round */
	private Map map;
	/** The player entity that will be controlled with cursors */
	private Entity player;

	private GameScreen gameScreen = new GameScreen("Game", 300, 300, false); // OBS! Skall Vara false.

	public Game(){
		map = new Map();
		gameScreen.setBackground(map);
		gameScreen.setKeyListener(this);
		
		keyDown.put("left", false);
		keyDown.put("right", false);
		keyDown.put("up", false);
		keyDown.put("down", false);

		loadImages();
		gameLoop();
	}

	public void loadImages(){
		sprite = new ImageIcon(getClass().getResource("/sprite.gif")).getImage();		
		player = new Entity(sprite, map, 1.5f, 1.5f);
	}

	public void update(long delta){
		// check the keyboard and record which way the player

		// is trying to move this loop

		float dx = 0;
		float dy = 0;
		if (keyDown.get("left")) {
			dx -= 1;
		}
		if (keyDown.get("right")) {
			dx += 1;
		}
		if (keyDown.get("up")) {
			dy -= 1;
		}
		if (keyDown.get("down")) {
			dy += 1;
		}

		// if the player needs to move attempt to move the entity

		// based on the keys multiplied by the amount of time thats

		// passed

		if ((dx != 0) || (dy != 0)) {
			player.move(dx * delta * 0.003f,
					dy * delta * 0.003f);
		}
	}

	public void render(){
		gameScreen.render(player);
	}

	public void gameLoop(){
		long last = System.nanoTime();
		while(gameRunning){
			long delta = (System.nanoTime() - last) / 1000000;
			last = System.nanoTime();

			// now this needs a bit of explaining. The amount of time

			// passed between rendering can vary quite alot. If we were

			// to move our player based on the normal delta it would

			// at times jump a long distance (if the delta value got really

			// high). So we divide the amount of time passed into segments

			// of 5 milliseconds and update based on that

			for (int i=0;i<delta / 5;i++) {
				update(5);
			}
			// after we've run through the segments if there is anything

			// left over we update for that

			if ((delta % 5) != 0) {
				update(delta % 5);
			}
			render();
			// Fördröjning
			try { Thread.sleep(4); } catch (Exception e) {};
		}
	}

	/** Spelets tangentbordslyssnare */
	public void keyTyped(KeyEvent e) {
	}

	public void keyPressed(KeyEvent e) {
		// check the keyboard and record which keys are pressed

		if (e.getKeyCode() == KeyEvent.VK_LEFT) {
			keyDown.put("left", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
			keyDown.put("right", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			keyDown.put("down", true);
		}
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			keyDown.put("up", true);
		}
	}

	public void keyReleased(KeyEvent e) {
		// check the keyboard and record which keys are released

		if (e.getKeyCode() == KeyEvent.VK_LEFT) {
			keyDown.put("left", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
			keyDown.put("right", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			keyDown.put("down", false);
		}
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			keyDown.put("up", false);
		}
	}

	public static void main(String[] args) {
		new Game();
	}
}
